package com.ejie.ab04b.dao.custom;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteOS3Dao;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteOS3Dao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TramiteOS3CustomDao extends TramiteOS3Dao {

	/**
	 * Finds a single row in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  TramiteOS3
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @return the tramite OS 3
	 */
	@Transactional(readOnly = true)
	public TramiteOS3 vfind(TramiteOS3 tramiteOS3);

	/**
	 * Finds a single row in the TramiteOS3 table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os3
	 *            OS3
	 *  TramiteOS3
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os3 the os 3
	 * @return the tramite OS 3
	 */
	@Transactional(readOnly = true)
	public TramiteOS3 findLastTramiteByTipo(Long idTipoTramite, OS3 os3);

	/**
	 * Finds a list of rows in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteOS3>
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS3> vfindAll(TramiteOS3 tramiteOS3,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TramiteOS3 table.
	 * 
	 *  filterAb0492s00
	 *            TramiteOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  b
	 *            boolean
	 *  List<TramiteOS3>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param b the b
	 * @return the list
	 */
	@Transactional(readOnly = true)
	List<TramiteOS3> findAllImprimirDocsOS3Like(TramiteOS3 filterAb0492s00,
			JQGridRequestDto jqGridRequestDto, boolean b);

	/**
	 * Finds a number of rows in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  b
	 *            boolean
	 *  List<TramiteOS3>
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @param b the b
	 * @return the long
	 */
	Long findAllLikeImprimirDocsOS3Count(TramiteOS3 tramiteOS3, boolean b);

}
